﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RevisionAnalyser.Global;

namespace RevisionAnalyser.Projects.RecoderProject
{
    public class SvnRevision : Revision
    {
        private string _author;
        public string Author
        {
            get
            {
                return _author;
            }
            set
            {
                _author = value;
            }
        }

        private string _logMessage;
        public string LogMessage
        {
            get
            {
                return _logMessage;
            }
            set
            {
                _logMessage = value;
            }
        }

        public SvnRevision(long id, string author, DateTime time, string logMessage)
        {
            _id = id;
            _author = author;
            _time = time;
            _logMessage = logMessage;
        }

        public override string ToString()
        {
            int length = LogMessage.Length < 100 ? LogMessage.Length : 100;
            return String.Format("Submitted by {0} on {1} with the message '{2}'", Author, Time.ToString(), LogMessage.Substring(0, length).Replace("\r\n", " "));
        }
    }
}
